using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{

    public partial class VmTemplate
    {

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return Id; }
        }

        private static readonly List<string> _vmProperties =
                        new List<string> { 
                            "name",
                            "domain",
                            "child_count",
                            "description",
                            "default_display_type",
                            "mem_size_mb",
                            "vds_group_name",
                            "status",
						    "time_zone",
                            "num_of_monitors",
                            "vds_group_id","usb_policy",
                            "num_of_sockets",
                            "cpu_per_socket",
						    "os",
                            "is_auto_suspend",
							"auto_startup",
							"priority",
							"default_boot_sequence",
							"is_stateless",
							"iso_path", 
                            "initrd_url",
                            "kernel_url",        
                            "kernel_params"};
        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _vmProperties; }
        }

        //public double ActualDiskSize
        //{
        //    get
        //    {
        //        if(_actualDiskSize == 0 && DiskImageMap != null)
        //        {
        //            foreach (DiskImage disk in DiskImageMap.Values)
        //            {
        //                _actualDiskSize += disk.ActualSize;
        //            }
        //        }
        //         return _actualDiskSize;
        //    }
        //}

        //public Dictionary<string, DiskImage> DiskImageMap
        //{
        //    get { return _diskMap; }
        //    set { _diskMap = value; }
        //}

        //public List<DiskImage> DiskList
        //{
        //    get { return _diskList; }
        //}

        #endregion

        // override object.Equals
        public override bool Equals(object obj)
        {
            bool returnValue = base.Equals(obj);
            if (!returnValue && obj != null && obj is VmTemplate)
            {
                returnValue = (Id == (obj as VmTemplate).Id);
            }
            return returnValue;
        }

        // override object.GetHashCode
        public override int GetHashCode()
        {
            return Id.GetHashCode();
        }
    }
}
